/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.coremod.client.gui.modules.GraveyardManagementWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class GraveyardManagementModuleView
extends AbstractBuildingModuleView {
    @NotNull
    private List<BlockPos> graves = new ArrayList<BlockPos>();
    @NotNull
    private List<String> restingCitizen = new ArrayList<String>();

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        this.graves = new ArrayList<BlockPos>();
        int size = buf.readInt();
        for (int i = 1; i <= size; ++i) {
            BlockPos pos = buf.func_179259_c();
            this.graves.add(pos);
        }
        this.restingCitizen = new ArrayList<String>();
        int sizeRIP = buf.readInt();
        for (int i = 1; i <= sizeRIP; ++i) {
            this.restingCitizen.add(buf.func_218666_n());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Window getWindow() {
        return new GraveyardManagementWindow(this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return "grave";
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.gui.workerhuts.enchanter.workers";
    }

    @NotNull
    public List<BlockPos> getGraves() {
        return this.graves;
    }

    public void cleanGraves() {
        for (BlockPos grave : new ArrayList<BlockPos>(this.graves)) {
            TileEntity entity = this.buildingView.getColony().getWorld().func_175625_s(grave);
            if (entity instanceof TileEntityGrave) continue;
            this.graves.remove(grave);
        }
    }

    @NotNull
    public List<String> getRestingCitizen() {
        return Collections.unmodifiableList(this.restingCitizen);
    }
}

